#########################################################################################
# Alessandro Bugliarelli 2023
# JLNT TCAD modeling
#########################################################################################
File{
	Grid		= "jlnt_pmos_msh.tdr"
	Plot		= "jlnt_pmos"
	Current		= "jlnt_pmos"
	Output		= "jlnt_pmos"
	Parameter	= "jlnt_pmos.par"
}

Electrode {
	{ name="Source"    Voltage=0.0 Schottky(Pinning(Model="Sze")) Workfunction = 5.05 }
	{ name="Drain"     Voltage=0.0 Schottky(Pinning(Model="Sze")) Workfunction = 5.05 }
	{ name="Gate"      Voltage=0.0 }
}

Physics{
	Fermi
	Mobility( DopingDep HighFieldSaturation ( ParameterSetName = "myHighField" ) Enormal )
	EffectiveIntrinsicDensity( Bennett )
	Recombination(SRH( DopingDep ))
	eQuantumPotential
	hQuantumPotential
#	eBarrierTunneling "NLM" (BarrierLowering)
	hBarrierTunneling "NLM" (BarrierLowering)
}

Physics(MaterialInterface = "Silicon/SiO2"){
	Traps(
		Acceptor Gaussian fromMidBandGap Conc=4.5e11
		EnergyMid=-0.3 EnergySig=0.2 
		eXsection=1e-14  hXsection=1e-14
	)
}

Math{
	Extrapolate
	RelErrControl
	NonLocal "NLM" (
		Electrode = "Drain"
		Electrode = "Source"
		Length = 1.0e-6		
		Digits = 5
		EnergyResolution = 0.001
	)
}

Plot{
	NonLocal
	eDensity hDensity
	eCurrent hCurrent
	eBarrierTunneling
	hBarrierTunneling
	TotalCurrent/Vector eCurrent/Vector hCurrent/Vector
	eMobility hMobility
	eVelocity hVelocity
	eEnormal hEnormal
	ElectricField/Vector Potential SpaceCharge
	eQuasiFermi hQuasiFermi
	Potential Doping SpaceCharge
	SRH Auger 
	AvalancheGeneration
	DonorConcentration AcceptorConcentration
	Doping
	eGradQuasiFermi/Vector hGradQuasiFermi/Vector
	eEparallel hEparalllel
	BandGap 
	BandGapNarrowing
	Affinity
	ConductionBand ValenceBand
	eQuantumPotential 
	hQuantumPotential
}

# Compute equilibrium solution
Solve {
	Poisson
	Save(FilePrefix="equil")

# Ramp gate to 0.5 V
	QuasiStationary(InitialStep=0.05 MaxStep=0.05 MinStep=0.0001 Goal{name=Gate voltage=0.5})
	{ Coupled { Poisson Electron Hole eQuantumPotential hQuantumPotential }	}

# Ramp drain to -1.1 V
	QuasiStationary(InitialStep=0.05 MaxStep=0.05 MinStep=0.0001 Goal{name=Drain voltage=-1.1})
	{ Coupled { Poisson Electron Hole eQuantumPotential hQuantumPotential }	}

# Compute transfer characteristics at VDS = -1.1 V - Saturation regime
	NewCurrentPrefix = "IDVG_sat_" 			# name of the file
	QuasiStationary(InitialStep=0.05 MaxStep=0.05 MinStep=0.0001 Goal{name=Gate voltage=-1.6})
	{ Coupled { Poisson Electron Hole eQuantumPotential hQuantumPotential }
	CurrentPlot ( Time = (range = (0 1) intervals = 40)) }

# Load initial conditions: VDS = 0.0 V	VGS = 0.0 V
	Load(FilePrefix="equil")
	NewCurrentPrefix="tmpfile"

# Ramp gate to 0.5 V
	QuasiStationary(InitialStep=0.05 MaxStep=0.05 MinStep=0.0001 Goal{name=Gate voltage=0.5})
		{ Coupled { Poisson Electron Hole eQuantumPotential hQuantumPotential }	}

# Ramp drain to -0.1 V
	QuasiStationary(InitialStep=0.05 MaxStep=0.05 MinStep=0.0001 Goal{name=Drain voltage=-0.1})
		{ Coupled { Poisson Electron Hole eQuantumPotential hQuantumPotential }	}

# Compute transfer characteristics at VDS = -0.1 V - Linear regime
	NewCurrentPrefix = "IDVG_lin_" 			# name of the file
	QuasiStationary(InitialStep=0.05 MaxStep=0.05 MinStep=0.0001 Goal{name=Gate voltage=-1.6})
	{ Coupled { Poisson Electron Hole eQuantumPotential hQuantumPotential }
	CurrentPlot ( Time = (range = (0 1) intervals = 40)) }
}

